<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class School extends Model 
{

    protected $table = 'schools';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function grades()
    {
        return $this->hasMany('App\Models\Grade');
    }

    public function teachers()
    {
        return $this->hasMany('App\Models\Teacher');
    }

}